import java.util.Arrays;
import java.util.Scanner;

public class MatrixOperations {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // Unos dimenzija matrice i podmatrica

        int N = scanner.nextInt();
        int M = scanner.nextInt();
        int K = scanner.nextInt();
        int L = scanner.nextInt();

        // Unos niza A
        int[] A = new int[N * M];
        for (int i = 0; i < N * M; i++) {
            A[i] = scanner.nextInt();
        }

        // Konverzija niza A u matricu
        int[][] matrixA = new int[N][M];
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < M; j++) {
                matrixA[i][j] = A[i * M + j];
            }
        }

        // Pronalaenje nabroja
        int max = Integer.MIN_VALUE;
        int maxRowIndex = 0;
        int maxColIndex = 0;
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < M; j++) {
                if (matrixA[i][j] > max) {
                    max = matrixA[i][j];
                    maxRowIndex = i;
                    maxColIndex = j;
                }
            }
        }

        // Premestanje najveg broja u srediju matricu
        int tmp = matrixA[N / 2][M / 2];
        matrixA[N / 2][M / 2] = max;
        matrixA[maxRowIndex][maxColIndex] = tmp;

        // Sortiranje svakog reda matrice tako da je naji broj na poziciji M/2
        int[][] sortedMatrix = new int[N][M];
        for (int i = 0; i < N; i++) {
            Arrays.sort(matrixA[i]);
            int idx = M / 2;
            for (int j = 0; j < M; j++) {
                sortedMatrix[i][j] = matrixA[i][(j + idx) % M];
            }
        }

        // Podela matrice na podmatrice dimenzija KxL
        int[][][] submatrices = new int[N - K + 1][M - L + 1][K * L];
        for (int i = 0; i < N - K + 1; i++) {
            for (int j = 0; j < M - L + 1; j++) {
                for (int k = 0; k < K; k++) {
                    for (int l = 0; l < L; l++) {
                        submatrices[i][j][k * L + l] = sortedMatrix[i + k][j + l];
                    }
                }
            }
        }

        // Sabiranje svih podmatrica
        int totalSum = 0;
        for (int i = 0; i < N - K + 1; i++) {
            for (int j = 0; j < M - L + 1; j++) {
                totalSum += Arrays.stream(submatrices[i][j]).sum();
            }
        }


        System.out.println(totalSum);
    }

    
}